

# ################################################
# (1) Constrained MLE
# ################################################

# {G-formula = {Y, M}, IPW = {M, A}, Mixed = {A, Y}, AIPW = {A, M, Y}}

optimize_nloptr <- function(dat, idx_test, func, beta_start, px, fmla, opt){
 
 fmla_y = fmla$fmla_y
 fmla_m = fmla$fmla_m
 fmla_a = fmla$fmla_a 
 
 tau_u = opt$tau_u
 tau_l = opt$tau_l
 estimator = opt$estimator
 
 # Prepare the data
 Xa = as.matrix(model.matrix(fmla_a, data=model.frame(dat, na.action = NULL))) 
 Xm = as.matrix(model.matrix(fmla_m, data=model.frame(dat, na.action = NULL)))
 Xy = as.matrix(model.matrix(fmla_y, data=model.frame(dat, na.action = NULL)))
 A = dat$A
 M = dat$M
 Y = dat$Y
 
 # Initial values for beta
 if (length(beta_start) == 0){
  if (estimator == "G-formula"){
   beta_start = rep(0.1, ncol(Xm) + ncol(Xy))
   names(beta_start) = c(colnames(Xm), colnames(Xy))
  }
  if (estimator == "IPW"){
   beta_start = rep(0.1, ncol(Xa) + ncol(Xm))
   names(beta_start) = c(colnames(Xa), colnames(Xm))
  }
  if (estimator == "Mixed"){
   beta_start = rep(0.1, ncol(Xa) + ncol(Xy))
   names(beta_start) = c(colnames(Xa), colnames(Xy))
  }
  if (estimator == "AIPW"){
   beta_start = rep(0.1, ncol(Xa) + ncol(Xm) + ncol(Xy))
   names(beta_start) = c(colnames(Xa), colnames(Xm), colnames(Xy))
  }
 }
 
 # Define the negative log likelihood function
 eval_f <- function(beta, dat, idx_test, Xa, Xm, Xy, A, M, Y, func, px, opt){
  n = length(Y)
  
  estimator = opt$estimator 
  
  if (estimator == "G-formula"){
   beta_m = beta[1:ncol(Xm)]
   beta_y = beta[(ncol(Xm)+1):length(beta)]
   names(beta_m) = colnames(Xm)
   names(beta_y) = colnames(Xy)
   Yhat = Xy%*%beta_y
   Y[idx_test] = Yhat[idx_test]
   
   
   
   f = M*log(1+exp(-Xm%*%beta_m)) + (1-M)*log(1+exp(Xm%*%beta_m)) + (Y - Yhat)^2/2 
  }
  if (estimator == "IPW"){
   beta_a = beta[1:ncol(Xa)]
   beta_m = beta[(ncol(Xa)+1):length(beta)]
   names(beta_a) = colnames(Xa)
   names(beta_m) = colnames(Xm)
   f = A*log(1+exp(-Xa%*%beta_a)) + (1-A)*log(1+exp(Xa%*%beta_a)) + M*log(1+exp(-Xm%*%beta_m)) + (1-M)*log(1+exp(Xm%*%beta_m)) 
  }
  if (estimator == "Mixed"){
   beta_a = beta[1:ncol(Xa)]
   beta_y = beta[(ncol(Xa)+1):length(beta)]
   names(beta_a) = colnames(Xa)
   names(beta_y) = colnames(Xy)
   Yhat = Xy%*%beta_y
   Y[idx_test] = Yhat[idx_test]
   f = A*log(1+exp(-Xa%*%beta_a)) + (1-A)*log(1+exp(Xa%*%beta_a)) + (Y - Yhat)^2/2 
  }
  if (estimator == "AIPW"){
   beta_a = beta[1:ncol(Xa)]
   beta_m = beta[(ncol(Xa)+1):(ncol(Xa)+ncol(Xm))]
   beta_y = beta[(ncol(Xa)+ncol(Xm)+1):length(beta)]
   names(beta_a) = colnames(Xa)
   names(beta_m) = colnames(Xm)
   names(beta_y) = colnames(Xy)
   Yhat = Xy%*%beta_y
   Y[idx_test] = Yhat[idx_test]
   f = A*log(1+exp(-Xa%*%beta_a))+(1-A)*log(1+exp(Xa%*%beta_a)) + M*log(1+exp(-Xm%*%beta_m))+(1-M)*log(1+exp(Xm%*%beta_m)) + (Y-Yhat)^2/2 
  }
  f = sum(f)/n 
  return(f)
 }
 
 # Define the inequlity constraint 
 eval_g_ineq <- function(beta, dat, idx_test, Xa, Xm, Xy, A, M, Y, func, px, opt){
  
  estimator = opt$estimator
  tau_u = opt$tau_u
  tau_l = opt$tau_l
  
  if (estimator == "G-formula"){
   beta_m = beta[1:ncol(Xm)]
   beta_y = beta[(ncol(Xm)+1):length(beta)]
   names(beta_m) = colnames(Xm)
   names(beta_y) = colnames(Xy)
   beta_par = list(beta_y=beta_y, beta_m=beta_m, beta_a=NULL)
   pse = func(dat, beta_par, px, opt)
  }
  if (estimator == "IPW"){
   beta_a = beta[1:ncol(Xa)]
   beta_m = beta[(ncol(Xa)+1):length(beta)]
   names(beta_a) = colnames(Xa)
   names(beta_m) = colnames(Xm)
   beta_par = list(beta_y=NULL, beta_m=beta_m, beta_a=beta_a)
   pse = func(dat, beta_par, px, opt)
  }
  if (estimator == "Mixed"){
   beta_a = beta[1:ncol(Xa)]
   beta_y = beta[(ncol(Xa)+1):length(beta)]
   names(beta_a) = colnames(Xa)
   names(beta_y) = colnames(Xy)
   beta_par = list(beta_y=beta_y, beta_m=NULL, beta_a=beta_a)
   pse = func(dat, beta_par, px, opt)
  }
  if (estimator == "AIPW"){
   beta_a = beta[1:ncol(Xa)]
   beta_m = beta[(ncol(Xa)+1):(ncol(Xa)+ncol(Xm))]
   beta_y = beta[(ncol(Xa)+ncol(Xm)+1):length(beta)]
   names(beta_a) = colnames(Xa)
   names(beta_m) = colnames(Xm)
   names(beta_y) = colnames(Xy)
   beta_par = list(beta_y=beta_y, beta_m=beta_m, beta_a=beta_a)
   pse = func(dat, beta_par, px, opt)
  }
  eval_g =  c(pse - tau_u, tau_l - pse)
  return(eval_g)
 }
 
 # Solve the optimization problem
 mle_res = nloptr(x0=beta_start, 
              eval_f=eval_f, 
              eval_g_ineq=eval_g_ineq,
              opts = list("algorithm"="NLOPT_LN_COBYLA","xtol_rel"=1.0e-8, "maxeval"=5000), 
              dat=dat, idx_test=idx_test, Xa=Xa, Xm=Xm, Xy=Xy, A=A, M=M, Y=Y, 
              func=func, px=px, opt=opt)

 
 # Returnt the parameters
 beta = mle_res$solution
 
 if (estimator == "G-formula"){
  beta_a = beta_0hat$beta_a
  
  beta_m = beta[1:ncol(Xm)]
  beta_y = beta[(ncol(Xm)+1):length(beta)]
  names(beta_m) = colnames(Xm)
  names(beta_y) = colnames(Xy)
 }
 if (estimator == "IPW"){
  beta_y = beta_0hat$beta_y
  
  beta_a = beta[1:ncol(Xa)]
  beta_m = beta[(ncol(Xa)+1):length(beta)]
  names(beta_a) = colnames(Xa)
  names(beta_m) = colnames(Xm)
 }
 if (estimator == "Mixed"){
  beta_m = beta_0hat$beta_m
  
  beta_a = beta[1:ncol(Xa)]
  beta_y = beta[(ncol(Xa)+1):length(beta)]
  names(beta_a) = colnames(Xa)
  names(beta_y) = colnames(Xy)
 }
 if (estimator == "AIPW"){
  beta_a = beta[1:ncol(Xa)]
  beta_m = beta[(ncol(Xa)+1):(ncol(Xa)+ncol(Xm))]
  beta_y = beta[(ncol(Xa)+ncol(Xm)+1):length(beta)]
  names(beta_a) = colnames(Xa)
  names(beta_m) = colnames(Xm)
  names(beta_y) = colnames(Xy)
 }
 
 Yhat = Xy%*%beta_y
 Y[idx_test] = Yhat[idx_test]
 p_Y = dnorm(Y, Yhat, 1)
 
 p_M1 = 1/(1+exp(-Xm%*%beta_m))
 p_M = M*p_M1 + (1-M)*(1-p_M1)
 
 p_A1 = 1/(1+exp(-Xa%*%beta_a))
 p_A = A*p_A1 + (1-A)*(1-p_A1)
 
 log_lik = sum(log(px) + log(p_A) + log(p_M) + log(p_Y))  
 
 return(list(beta_a=beta_a, 
             beta_m=beta_m, 
             beta_y=beta_y, 
             mle = log_lik))
}



